<table class="table bg-gray">
        <tr class="bg-green">
        <th>#</th>
        <th><?php echo e(__('sale.product')); ?></th>
        <?php if( session()->get('business.enable_lot_number') == 1): ?>
            <th><?php echo e(__('lang_v1.lot_n_expiry')); ?></th>
        <?php endif; ?>
        <th><?php echo e(__('sale.qty')); ?></th>
        <?php if(!empty($pos_settings['inline_service_staff'])): ?>
            <th>
                <?php echo e(app('translator')->getFromJson('restaurant.service_staff')); ?>
            </th>
        <?php endif; ?>
        <th><?php echo e(__('sale.unit_price')); ?></th>
        <th><?php echo e(__('sale.discount')); ?></th>
        <th><?php echo e(__('sale.tax')); ?></th>
        <th><?php echo e(__('sale.price_inc_tax')); ?></th>
        <th><?php echo e(__('sale.subtotal')); ?></th>
    </tr>
    <?php $__currentLoopData = $sell->sell_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sell_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td>
                <?php echo e($sell_line->product->name); ?>

                <?php if( $sell_line->product->type == 'variable'): ?>
                - <?php echo e(isset($sell_line->variations->product_variation->name) ? $sell_line->variations->product_variation->name : ''); ?>

                - <?php echo e(isset($sell_line->variations->name) ? $sell_line->variations->name : ''); ?>,
                <?php endif; ?>
                <?php echo e(isset($sell_line->variations->sub_sku) ? $sell_line->variations->sub_sku : ''); ?>

                <?php
                $brand = $sell_line->product->brand;
                ?>
                <?php if(!empty($brand->name)): ?>
                , <?php echo e($brand->name); ?>

                <?php endif; ?>

                <?php if(!empty($sell_line->sell_line_note)): ?>
                <br> <?php echo e($sell_line->sell_line_note); ?>

                <?php endif; ?>
            </td>
            <?php if( session()->get('business.enable_lot_number') == 1): ?>
                <td><?php echo e(isset($sell_line->lot_details->lot_number) ? $sell_line->lot_details->lot_number : '--'); ?>

                    <?php if( session()->get('business.enable_product_expiry') == 1 && !empty($sell_line->lot_details->exp_date)): ?>
                    (<?php echo e(\Carbon::createFromTimestamp(strtotime($sell_line->lot_details->exp_date))->format(session('business.date_format'))); ?>)
                    <?php endif; ?>
                </td>
            <?php endif; ?>
            <td>
                <span class="display_currency" data-currency_symbol="false" data-is_quantity="true"><?php echo e($sell_line->quantity); ?></span> <?php if(!empty($sell_line->sub_unit)): ?> <?php echo e($sell_line->sub_unit->short_name); ?> <?php else: ?> <?php echo e($sell_line->product->unit->short_name); ?> <?php endif; ?>
            </td>
            <?php if(!empty($pos_settings['inline_service_staff'])): ?>
                <td>
                <?php echo e($sell_line->service_staff->user_full_name ?? ''); ?>

                </td>
            <?php endif; ?>
            <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($sell_line->unit_price_before_discount); ?></span>
            </td>
            <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($sell_line->get_discount_amount()); ?></span> <?php if($sell_line->line_discount_type == 'percentage'): ?> (<?php echo e($sell_line->line_discount_amount); ?>%) <?php endif; ?>
            </td>
            <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($sell_line->item_tax); ?></span> 
                <?php if(!empty($taxes[$sell_line->tax_id])): ?>
                ( <?php echo e($taxes[$sell_line->tax_id]); ?> )
                <?php endif; ?>
            </td>
            <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($sell_line->unit_price_inc_tax); ?></span>
            </td>
            <td>
                <span class="display_currency" data-currency_symbol="true"><?php echo e($sell_line->quantity * $sell_line->unit_price_inc_tax); ?></span>
            </td>
        </tr>
        <?php if(!empty($sell_line->modifiers)): ?>
        <?php $__currentLoopData = $sell_line->modifiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>&nbsp;</td>
                <td>
                    <?php echo e($modifier->product->name); ?> - <?php echo e(isset($modifier->variations->name) ? $modifier->variations->name : ''); ?>,
                    <?php echo e(isset($modifier->variations->sub_sku) ? $modifier->variations->sub_sku : ''); ?>

                </td>
                <?php if( session()->get('business.enable_lot_number') == 1): ?>
                    <td>&nbsp;</td>
                <?php endif; ?>
                <td><?php echo e($modifier->quantity); ?></td>
                <td>
                    <span class="display_currency" data-currency_symbol="true"><?php echo e($modifier->unit_price); ?></span>
                </td>
                <td>
                    &nbsp;
                </td>
                <td>
                    <span class="display_currency" data-currency_symbol="true"><?php echo e($modifier->item_tax); ?></span> 
                    <?php if(!empty($taxes[$modifier->tax_id])): ?>
                    ( <?php echo e($taxes[$modifier->tax_id]); ?> )
                    <?php endif; ?>
                </td>
                <td>
                    <span class="display_currency" data-currency_symbol="true"><?php echo e($modifier->unit_price_inc_tax); ?></span>
                </td>
                <td>
                    <span class="display_currency" data-currency_symbol="true"><?php echo e($modifier->quantity * $modifier->unit_price_inc_tax); ?></span>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table>